# Changelog

Changes to the Randolph Glacier Inventory since version 6.0 are documented here. 

## 6.2 (2019-05-20)

### Structure: Fixed

- added a `LICENSE.txt` file to the data folder specifying the RGI License as "CC BY 4.0" 
  (Creative Commons Attribution 4.0 International license)
- added a `CHANGELOG.md` file
- the file `08_rgi60_Scandinavia.shp` was located in a folder wrongly entitled 
  `07_rgi60_Scandinavia`. The new folder is now correctly named `08_rgi60_Scandinavia`
- the file `04_rgi60_ArcticCanadaSouth.shp` was located in a folder wrongly entitled 
  `04_rgi60_ArcticCanadaNorth`. The new folder is now correctly named `04_rgi60_ArcticCanadaSouth`

### Data: Fixed

- the geometries have been fixed according to rgitools standard. A new column of data 
  (`check_geom`) was added for this purpose. Visit https://rgitools.readthedocs.io for more info.
- the geometries describing the RGI regions (`00_rgi60_O1Regions.shp`) and subregions 
  (`00_rgi60_O2Regions.shp`) have been sligtlhy modified. The code changing these files is found
  [here](https://github.com/OGGM/rgitools/tree/master/notebooks/rgi_60_corrections) and did 
  the following:
    - the outlines of RGI region 12 (Caucasus and Middle East) and subregion 12-02 (Central 
      Siberia) have been modified to reach down to 30°N (instead of 31°N previously). This was
      done to encompass a cluster of 9 glaciers which was located below the previous polygon.
    - the outlines of RGI regions 1 (Alaska) and 2 (Western Canada and USA) have been slightly 
      modified at two locations in order to correctly encompass the glaciers `RGI60-01.05285` 
      and `RGI60-02.11958` which were otherwise attributed to the wrong region.
    - the outlines of RGI sub-regions 01-06 (N Coast Ranges), 02-02 (S Coast Ranges) and 02-03 
      (N Rocky Mtns) have been slightly modified for the same reasons as above.
- 140 glaciers have been attributed a new RGI sub-region number, in accordance to the 
  `00_rgi60_O2Regions.shp` which serves as reference. The majority (116) of these corrected 
  glaciers are nominal glacier at high latitudess, but some other glaciers are simply close to 
  the region's boundary and were obviously mis-attributed. All glaciers in the RGI now pass the 
  test: `region_polygon.contains(rgi_entity)`.
- [TODO]: the `00_rgi60_attribs` and `00_rgi60_summary.csv` have been corrected according to the 
  changes above.

